Object.assign(window.search, {"doc_urls":["introduction.html#faq","introduction.html#who","introduction.html#what-is-cuprated","introduction.html#does-cuprated-replace-monerod","introduction.html#is-it-safe-to-run-cuprated","introduction.html#what-files-does-cuprated-create","introduction.html#what-can-cuprated-currently-do","introduction.html#how-fast-does-cuprated-sync","introduction.html#how-to-see-status-of-cuprated","introduction.html#how-to-tell-cuprated-is-fully-synced","introduction.html#how-big-is-the-database","introduction.html#is-the-database-compatible-with-monerod","introduction.html#can-i-connect-a-wallet-to-cuprated","introduction.html#can-cuprated-be-used-with-an-anonymity-network-like-tor","introduction.html#cuprated-wont-start-because-of-a-killswitch-why","introduction.html#what-is-the-release-schedule","introduction.html#what-is-the-versioning-scheme","introduction.html#what-is-the-current-progress","introduction.html#what-is-the-current-roadmap","getting-started/intro.html#getting-started","getting-started/sys-req.html#system-requirements","getting-started/download.html#download","getting-started/source.html#building-from-source","getting-started/source.html#linux","getting-started/source.html#macos","getting-started/run.html#running","config.html#configuration","config.html#cupratedtoml","cli.html#command-line","cli.html#--version","resources/intro.html#resources","resources/disk.html#disk","resources/disk.html#cache","resources/disk.html#configuration","resources/disk.html#data","resources/ports.html#ports","resources/ip.html#ip","deployment/intro.html#deployment","deployment/systemd.html#systemd","platform.html#platform-support","platform.html#tier-1","platform.html#tier-2","platform.html#tier-3","license.html#license"],"index":{"documentStore":{"docInfo":{"0":{"body":44,"breadcrumbs":2,"title":1},"1":{"body":23,"breadcrumbs":1,"title":0},"10":{"body":15,"breadcrumbs":3,"title":2},"11":{"body":13,"breadcrumbs":4,"title":3},"12":{"body":13,"breadcrumbs":4,"title":3},"13":{"body":9,"breadcrumbs":6,"title":5},"14":{"body":22,"breadcrumbs":5,"title":4},"15":{"body":12,"breadcrumbs":3,"title":2},"16":{"body":19,"breadcrumbs":3,"title":2},"17":{"body":19,"breadcrumbs":3,"title":2},"18":{"body":7,"breadcrumbs":3,"title":2},"19":{"body":6,"breadcrumbs":4,"title":2},"2":{"body":40,"breadcrumbs":2,"title":1},"20":{"body":81,"breadcrumbs":6,"title":2},"21":{"body":72,"breadcrumbs":4,"title":1},"22":{"body":26,"breadcrumbs":6,"title":2},"23":{"body":51,"breadcrumbs":5,"title":1},"24":{"body":33,"breadcrumbs":5,"title":1},"25":{"body":20,"breadcrumbs":4,"title":1},"26":{"body":26,"breadcrumbs":2,"title":1},"27":{"body":748,"breadcrumbs":2,"title":1},"28":{"body":69,"breadcrumbs":4,"title":2},"29":{"body":79,"breadcrumbs":3,"title":1},"3":{"body":13,"breadcrumbs":4,"title":3},"30":{"body":6,"breadcrumbs":2,"title":1},"31":{"body":11,"breadcrumbs":3,"title":1},"32":{"body":29,"breadcrumbs":3,"title":1},"33":{"body":22,"breadcrumbs":3,"title":1},"34":{"body":42,"breadcrumbs":3,"title":1},"35":{"body":27,"breadcrumbs":3,"title":1},"36":{"body":24,"breadcrumbs":3,"title":1},"37":{"body":5,"breadcrumbs":2,"title":1},"38":{"body":169,"breadcrumbs":3,"title":1},"39":{"body":37,"breadcrumbs":4,"title":2},"4":{"body":26,"breadcrumbs":4,"title":3},"40":{"body":30,"breadcrumbs":4,"title":2},"41":{"body":23,"breadcrumbs":4,"title":2},"42":{"body":56,"breadcrumbs":4,"title":2},"43":{"body":17,"breadcrumbs":2,"title":1},"5":{"body":2,"breadcrumbs":4,"title":3},"6":{"body":16,"breadcrumbs":3,"title":2},"7":{"body":42,"breadcrumbs":4,"title":3},"8":{"body":12,"breadcrumbs":4,"title":3},"9":{"body":23,"breadcrumbs":5,"title":4}},"docs":{"0":{"body":"Cuprate is an alternative and independent Monero node implementation that is focused on being fast, user-friendly, and backwards compatible with monerod . This project is currently a work-in-progress; the cuprated node can be ran by users although it is not yet ready for production. This book contains brief sections documenting cuprated usage, however, be aware that it is incomplete and missing sections. To get started, see: Getting started . Frequently asked questions about Cuprate.","breadcrumbs":"Introduction » FAQ","id":"0","title":"FAQ"},"1":{"body":"Cuprate was started by SyntheticBird45 in early 2023 and was later joined by boog900 , hinto-janai , and other contributors . A few Cuprate contributors are funded by Monero's Community Crowdfunding System to work on Cuprate and occasionally monerod.","breadcrumbs":"Introduction » Who?","id":"1","title":"Who?"},"10":{"body":"As of May 1st 2025, cuprated's database is ~270GB in size. monerod's database is ~225GB in size. This is 1.2x larger. This is planned to be improved in the future.","breadcrumbs":"Introduction » How big is the database?","id":"10","title":"How big is the database?"},"11":{"body":"No. The database cuprated generates and uses cannot directly be used by monerod and vice-versa. Supporting this is possible but there are no current plans to do so.","breadcrumbs":"Introduction » Is the database compatible with monerod?","id":"11","title":"Is the database compatible with monerod?"},"12":{"body":"Not yet. Wallets require the daemon RPC API . This is actively being worked on to be backwards compatible with monerod, although this is not yet available.","breadcrumbs":"Introduction » Can I connect a wallet to cuprated?","id":"12","title":"Can I connect a wallet to cuprated?"},"13":{"body":"Not yet (directly). Tor is planned to be integrated into cuprated via arti , although this is not yet available.","breadcrumbs":"Introduction » Can cuprated be used with an anonymity network like Tor?","id":"13","title":"Can cuprated be used with an anonymity network like Tor?"},"14":{"body":"The current alpha builds of cuprated contain killswitches that activate 1 week after the next release is out. If the killswitch activates, you must upgrade to the latest release . The reasoning for why this exists can be found here: https://github.com/Cuprate/cuprate/pull/365 .","breadcrumbs":"Introduction » cuprated won't start because of a \"killswitch\", why?","id":"14","title":"cuprated won't start because of a \"killswitch\", why?"},"15":{"body":"New versions of cuprated are planned to release every 4 weeks. See this GitHub issue for more details.","breadcrumbs":"Introduction » What is the release schedule?","id":"15","title":"What is the release schedule?"},"16":{"body":"cuprated is currently in alpha (0.0.x). After sufficient testing and development, cuprated will enter beta (0.x.y) then stable (x.y.z) releases. See this GitHub issue for more details.","breadcrumbs":"Introduction » What is the versioning scheme?","id":"16","title":"What is the versioning scheme?"},"17":{"body":"See this Reddit thread for a brief report on Cuprate's progress throughout 2024. Things are always changing so feel free to join our Matrix channel and ask questions.","breadcrumbs":"Introduction » What is the current progress?","id":"17","title":"What is the current progress?"},"18":{"body":"See this GitHub issue for Cuprate's rough 2025 roadmap.","breadcrumbs":"Introduction » What is the current roadmap?","id":"18","title":"What is the current roadmap?"},"19":{"body":"This section contains information on downloading/building and running cuprated.","breadcrumbs":"Getting started » Getting started","id":"19","title":"Getting started"},"2":{"body":"monerod is the daemon of the Monero project, the Monero node. cuprated is the daemon of the Cuprate project, the Cuprate node. Both operate on the same network, the Monero network, and are responsible for roughly the same tasks. For more information on the role of alternative node implementations, see: https://clientdiversity.org https://bchfaq.com/knowledge-base/what-are-the-full-node-implementations-for-bitcoin-cash https://zfnd.org/zebra-stable-release","breadcrumbs":"Introduction » What is cuprated?","id":"2","title":"What is cuprated?"},"20":{"body":"cuprated has the following hardware requirements. Hardware requirement Recommended Minimum CPU 8+ cores 1 core RAM 8+ GB 2 GB Disk (space) 500+ GB 300 GB Disk (speed) 100+ MB/s writes ~5 MB/s writes Network (speed) 30+ MB/s up/down ~1 MB/s up/down Network (bandwidth) 1 TB+ per month ~300 GB per month Note that cuprated: Benefits greatly from high-end hardware Can run on weaker hardware (last tested on a Raspberry Pi 4 (2GB RAM) and Raspberry Pi 5 (8 GB RAM)) Requires tweaking the config for your system, especially if you are at either extremes of the hardware scale","breadcrumbs":"Getting started » System requirements » System requirements","id":"20","title":"System requirements"},"21":{"body":"Cuprate offers pre-built binaries for cuprated for the platforms listed in Platform support using GitHub CI in a non-reproducible way for convenience; it is highly recommended to build cuprated from source instead, see Building from source . Platform Download Windows x86_64 https://github.com/Cuprate/cuprate/releases/download/cuprated-0.0.3/cuprated-0.0.3-windows-x64.zip macOS x86_64 https://github.com/Cuprate/cuprate/releases/download/cuprated-0.0.3/cuprated-0.0.3-macos-x64.tar.gz macOS ARM64 https://github.com/Cuprate/cuprate/releases/download/cuprated-0.0.3/cuprated-0.0.3-macos-arm64.tar.gz Linux x86_64 (glibc >= 2.36) https://github.com/Cuprate/cuprate/releases/download/cuprated-0.0.3/cuprated-0.0.3-linux-x64.tar.gz Linux ARM64 (glibc >= 2.36) https://github.com/Cuprate/cuprate/releases/download/cuprated-0.0.3/cuprated-0.0.3-linux-arm64.tar.gz All release files are archived and also available at https://archive.hinto.rs .","breadcrumbs":"Getting started » Download » Download","id":"21","title":"Download"},"22":{"body":"To build cuprated from source you will need: git Up-to-date Rust toolchain Compiler toolchain Certain system dependencies To install Rust, follow these instructions or run: curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh","breadcrumbs":"Getting started » Building from source » Building from source","id":"22","title":"Building from source"},"23":{"body":"Install the required system dependencies: # Debian/Ubuntu\nsudo apt install -y build-essential cmake git # Arch\nsudo pacman -Syu base-devel cmake git # Fedora\nsudo dnf install @development-tools gcc gcc-c++ cmake git Clone the Cuprate repository and build: git clone https://github.com/Cuprate/cuprate\ncd cuprate/\ncargo build --release --package cuprated The built cuprated binary should be located at target/release/cuprated.","breadcrumbs":"Getting started » Building from source » Linux","id":"23","title":"Linux"},"24":{"body":"Install Homebrew : /bin/bash -c \"$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)\" Install the required system dependencies: brew install cmake Clone the Cuprate repository and build: git clone https://github.com/Cuprate/cuprate\ncd cuprate/\ncargo build --release --package cuprated The built cuprated binary should be located at target/release/cuprated.","breadcrumbs":"Getting started » Building from source » macOS","id":"24","title":"macOS"},"25":{"body":"To run cuprated: ./cuprated --config-file Cuprated.toml cuprated can be ran without a config file although it is recommended to use one; see Configuration for a default config file.","breadcrumbs":"Getting started » Running » Running","id":"25","title":"Running"},"26":{"body":"cuprated reads its configuration file Cuprated.toml on startup - this is in the TOML file format. cuprated will try to look for Cuprated.toml in the follow places, in order: PATH specified in --config-file Current directory: ./Cuprated.toml OS specific directory","breadcrumbs":"Configuration » Configuration","id":"26","title":"Configuration"},"27":{"body":"This is the default configuration file cuprated creates and uses. If cuprated is started with no --options , then the configuration used will be equivalent to this config file. Some values may be different for your exact system, generate the config with cuprated --generate-config to see the defaults for your system. ## ____ _\n## / ___| _ _ __ _ __ __ _| |_ ___\n## | | | | | | '_ \\| '__/ _` | __/ _ \\\n## | |__| |_| | |_) | | | (_| | || __/\n## \\____\\__,_| .__/|_| \\__,_|\\__\\___|\n## |_|\n##\n## All these config values can be set to\n## their default by commenting them out with '#'.\n##\n## Some values are already commented out,\n## to set the value remove the '#' at the start of the line.\n##\n## For more documentation, see: <https://user.cuprate.org>. ## The network cuprated should run on.\n##\n## Valid values | \"Mainnet\", \"Testnet\", \"Stagenet\"\nnetwork = \"Mainnet\"\n## Enable/disable fast sync.\n##\n## Fast sync skips verification of old blocks by\n## comparing block hashes to a built-in hash file,\n## disabling this will significantly increase sync time.\n## New blocks are still fully validated.\n##\n## Type | boolean\n## Valid values | true, false\nfast_sync = true ## Configuration for cuprated's stdout logging system.\n[tracing.stdout]\n## The minimum log level for stdout.\n##\n## Levels below this one will not be shown.\n## \"error\" is the highest level only showing errors,\n## \"trace\" is the lowest showing as much as possible.\n##\n## Type | Level\n## Valid values | \"error\", \"warn\", \"info\", \"debug\", \"trace\"\nlevel = \"info\" ## Configuration for cuprated's file logging system.\n[tracing.file]\n## The minimum log level for file logs.\n##\n## Levels below this one will not be shown.\n## \"error\" is the highest level only showing errors,\n## \"trace\" is the lowest showing as much as possible.\n##\n## Type | Level\n## Valid values | \"error\", \"warn\", \"info\", \"debug\", \"trace\"\nlevel = \"debug\"\n## The maximum amount of log files to keep.\n##\n## Once this number is passed the oldest file will be deleted.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 0, 7, 200\nmax_log_files = 7 ## Configuration for cuprated's asynchronous runtime system, tokio.\n##\n## Tokio is used for network operations and the major services inside `cuprated`.\n[tokio]\n## The amount of threads to spawn for the tokio thread-pool.\n##\n## Type | Number\n## Valid values | >= 1\n## Examples | 1, 8, 14\n#threads = 5 ## Configuration for cuprated's thread-pool system, rayon.\n##\n## Rayon is used for CPU intensive tasks.\n[rayon]\n## Type | Number\n## Valid values | >= 1\n## Examples | 1, 8, 14\n#threads = 5 ## The clear-net P2P config.\n[p2p.clear_net]\n## The IP address to bind and listen for connections on.\n##\n## Type | IPv4/IPv6 address\n## Examples | \"0.0.0.0\", \"192.168.1.50\", \"::\"\nlisten_on = \"0.0.0.0\"\n## The number of outbound connections to make and try keep.\n##\n## It's recommended to keep this value above 12.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 12, 32, 64, 100, 500\n#outbound_connections = 32\n## The amount of extra connections to make if cuprated is under load.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 0, 12, 32, 64, 100, 500\n#extra_outbound_connections = 8\n## The maximum amount of inbound connections to allow.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 0, 12, 32, 64, 100, 500\n#max_inbound_connections = 128\n## The percent of connections that should be\n## to peers that haven't connected to before.\n##\n## 0.0 is 0%.\n## 1.0 is 100%.\n##\n## Type | Floating point number\n## Valid values | 0.0..1.0\n## Examples | 0.0, 0.5, 0.123, 0.999, 1.0\n#gray_peers_percent = 0.7\n## The port to use to accept incoming P2P connections.\n##\n## Setting this to 0 will disable incoming P2P connections.\n##\n## Type | Number\n## Valid values | 0..65534\n## Examples | 18080, 9999, 5432\np2p_port = 18080 ## The address book config.\n[p2p.clear_net.address_book_config]\n## The size of the white peer list.\n##\n## The white list holds peers that have been connected to before.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 1000, 500, 241\nmax_white_list_length = 1000\n## The size of the gray peer list.\n##\n## The gray peer list holds peers that have been\n## told about but not connected to cuprated.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 1000, 500, 241\nmax_gray_list_length = 5000\n## The time period between address book saves.\n##\n## Type | Duration\n## Examples | { secs = 90, nanos = 0 }, { secs = 100, nano = 123 }\npeer_save_period = { secs = 90, nanos = 0 } ## Block downloader config.\n##\n## The block downloader handles downloading old blocks from peers when we are behind.\n[p2p.block_downloader]\n## The size in bytes of the buffer between the block downloader\n## and the place which is consuming the downloaded blocks (`cuprated`).\n##\n## This value is an absolute maximum,\n## once this is reached the block downloader will pause.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 1_000_000_000, 5_500_000_000, 500_000_000\n#buffer_bytes = 1000000000\n## The size of the in progress queue (in bytes)\n## at which cuprated stops requesting more blocks.\n##\n## The value is _NOT_ an absolute maximum,\n## the in-progress queue could get much larger.\n## This value is only the value cuprated stops requesting more blocks,\n## if cuprated still has requests in progress,\n## it will still accept the response and add the blocks to the queue.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 500_000_000, 1_000_000_000,\n#in_progress_queue_bytes = 500000000\n## The target size of a single batch of blocks (in bytes).\n##\n## This value must be below 100_000,000,\n## it is not recommended to set it above 30_000_000.\n##\n## Type | Number\n## Valid values | 0..100_000,000\n#target_batch_bytes = 15000000\n## The duration between checking the client pool for free peers.\n##\n## Type | Duration\n## Examples | { secs = 30, nanos = 0 }, { secs = 35, nano = 123 }\ncheck_client_pool_interval = { secs = 30, nanos = 0 } ## Configuration for persistent data storage.\n[storage]\n## The amount of reader threads to spawn for the tx-pool and blockchain.\n##\n## The tx-pool and blockchain both share a single threadpool.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 1, 16, 10\n#reader_threads = 2 ## The tx-pool config.\n[storage.txpool]\n## The sync mode of the database.\n##\n## Using \"Safe\" makes the DB less likely to corrupt\n## if there is an unexpected crash, although it will\n## make DB writes much slower.\n##\n## Valid values | \"Fast\", \"Safe\"\n#sync_mode = \"Fast\"\n## The maximum size of the tx-pool.\n##\n## Type | Number\n## Valid values | >= 0\n## Examples | 100_000_000, 50_000_000\nmax_txpool_byte_size = 100000000 ## The blockchain config.\n[storage.blockchain]\n## The sync mode of the database.\n##\n## Using \"Safe\" makes the DB less likely to corrupt\n## if there is an unexpected crash, although it will\n## make DB writes much slower.\n##\n## Valid values | \"Fast\", \"Safe\"\n#sync_mode = \"Fast\" ## Configuration for the file-system.\n[fs]\n## The data directory.\n##\n## This directory store the blockchain, transaction pool,\n## log files, and any misc data files.\n##\n## The default directories for each OS:\n##\n## | OS | Path |\n## |---------|-----------------------------------------------------|\n## | Windows | \"C:\\Users\\Alice\\AppData\\Roaming\\Cuprate\\\" |\n## | macOS | \"/Users/Alice/Library/Application Support/Cuprate/\" |\n## | Linux | \"/home/alice/.local/share/cuprate/\" |\n#data_directory = \"/home/git/.local/share/cuprate\"\n## The cache directory.\n##\n## This directory store cache files.\n## Although not recommended, this directory can be\n## deleted without major disruption to cuprated.\n##\n## The default directories for each OS:\n##\n## | OS | Path |\n## |---------|-----------------------------------------|\n## | Windows | \"C:\\Users\\Alice\\AppData\\Local\\Cuprate\\\" |\n## | macOS | \"/Users/Alice/Library/Caches/Cuprate/\" |\n## | Linux | \"/home/alice/.cache/cuprate/\" |\n#cache_directory = \"/home/git/.cache/cuprate\"","breadcrumbs":"Configuration » Cuprated.toml","id":"27","title":"Cuprated.toml"},"28":{"body":"Command line options will override any overlapping config values. Usage: cuprated [OPTIONS] Option Description Default Possible values --network <NETWORK> The network to run on mainnet mainnet, testnet, stagenet --outbound-connections <OUTBOUND_CONNECTIONS> The amount of outbound clear-net connections to maintain 64 --config-file <CONFIG_FILE> The PATH of the cuprated config file Cuprated.toml --generate-config Generate a config file and print it to stdout --skip-config-warning Stops the missing config warning and startup delay if a config file is missing --version Print misc version information in JSON --help Print help","breadcrumbs":"Command line » Command line","id":"28","title":"Command line"},"29":{"body":"The --version flag outputs the following info in JSON. Field Type Description major_version Number Major version of cuprated minor_version Number Minor version of cuprated patch_version Number Patch version of cuprated rpc_major_version Number Major RPC version (follows monerod) rpc_minor_version Number Minor RPC version (follows monerod) rpc_version Number RPC version (follows monerod) hardfork Number Current hardfork version blockchain_db_version Number Blockchain database version (separate from monerod) semantic_version String Semantic version of cuprated build String Build of cuprated, either debug or release commit String git commit hash of cuprated killswitch_timestamp Number Timestamp at which cuprated's killswitch activates","breadcrumbs":"Command line » --version","id":"29","title":"--version"},"3":{"body":"No. cuprated cannot currently replace monerod in production environments. With that said, there will be practical performance benefits for users to use cuprated eventually.","breadcrumbs":"Introduction » Does cuprated replace monerod?","id":"3","title":"Does cuprated replace monerod?"},"30":{"body":"This section documents the system resources cuprated uses.","breadcrumbs":"Resources » Resources","id":"30","title":"Resources"},"31":{"body":"cuprated requires at least ~300 GB of disk storage for operation although 500+ GB is recommended.","breadcrumbs":"Resources » Disk » Disk","id":"31","title":"Disk"},"32":{"body":"The directory used for cache files is: OS Directory Windows C:\\Users\\User\\AppData\\Local\\Cuprate\\ macOS /Users/User/Library/Caches/Cuprate/ Linux /home/user/.cache/cuprate/ Although not recommended, this directory can be deleted without major disruption to cuprated. The files in this directory are: File Purpose addressbook/ClearNet P2P state for clear-net","breadcrumbs":"Resources » Disk » Cache","id":"32","title":"Cache"},"33":{"body":"The directory used for files related to configuration is: OS Directory Windows C:\\Users\\User\\AppData\\Roaming\\Cuprate\\ macOS /Users/User/Library/Application Support/Cuprate/ Linux /home/user/.config/cuprate/ The files in this directory are: File Purpose Cuprated.toml cuprated configuration file","breadcrumbs":"Resources » Disk » Configuration","id":"33","title":"Configuration"},"34":{"body":"The directory used for general data is: OS Directory Windows C:\\Users\\User\\AppData\\Roaming\\Cuprate\\ macOS /Users/User/Library/Application Support/Cuprate/ Linux /home/user/.local/share/cuprate/ The files in this directory are: File Purpose blockchain/data.mdb Blockchain database file blockchain/lock.mdb Blockchain database lock txpool/data.mdb Transaction pool database file txpool/lock.mdb Transaction pool database lock logs/{YYYY-MM-DD} Log files for each day","breadcrumbs":"Resources » Disk » Data","id":"34","title":"Data"},"35":{"body":"cuprated currently uses a single port to accept incoming P2P connections. By default, this port is 18080. See the p2p_port option in the config file to manually set this port. Setting the port to 0 will disable incoming P2P connections.","breadcrumbs":"Resources » Ports » Ports","id":"35","title":"Ports"},"36":{"body":"cuprated currently binds to a single IPv4 address for P2P connections. By default, this IP address is 0.0.0.0, which will bind to all available interfaces. See the listen_on option in the config file to manually set this IP address.","breadcrumbs":"Resources » IP » IP","id":"36","title":"IP"},"37":{"body":"This section covers ways of deploying cuprated.","breadcrumbs":"Deployment » Deployment","id":"37","title":"Deployment"},"38":{"body":"cuprated can be ran as a systemd service, the below are commands to setup a relatively hardened deployment. # Create the `cuprate` user\nsudo useradd --system --shell /sbin/nologin --home-dir /home/cuprate cuprate # Move `cuprated` and the config file\n# into the appropriate location.\nmv cuprated Cuprated.toml /home/cuprate/ # Move the service file to the appropriate location.\nsudo mv cuprated.service /etc/systemd/system/ # Start the `cuprated` service.\nsudo systemctl daemon-reload\nsudo systemctl start cuprated # (Optional) start `cuprated` upon boot.\nsudo systemctl enable cuprated A relatively hardened systemd service file for cuprated: ## cuprated.service\n##\n## This file is a relatively hardened systemd\n## service for `cuprated`, it:\n##\n## - requires a `cuprate` user exists\n## - restricts filesystem access to `/home/cuprate`\n## - requires `/home/cuprate/cuprated`\n## and `/home/cuprate/Cuprated.toml` exist\n##\n## For service file documentation, see:\n## <https://www.freedesktop.org/software/systemd/man/latest/systemd.exec.html> [Unit]\nDescription=Cuprate Monero Node\nStartLimitIntervalSec=300\nStartLimitBurst=5 [Service]\n## User.\nUser=cuprate\nGroup=cuprate\nType=simple ## Max memory.\nMemoryAccounting=yes\nMemoryHigh=4G\nMemoryMax=4G ## Start command.\nExecStart=/home/cuprate/cuprated --config-file /home/cuprate/Cuprated.toml ## Restart every 5s on failure.\nKillSignal=SIGINT\nRestart=on-failure\nRestartSec=5s ## Open file limit.\nLimitNOFILE=16384 ## On exit, wait 1 minute before sending SIGKILL.\nTimeoutStopSec=60s\nSendSIGKILL=true ## Restrict filesystem access.\nBindPaths=/home/cuprate ## Security hardening.\nSystemCallFilter=@system-service\nSystemCallFilter=~@privileged @resources CapabilityBoundingSet=\nDeviceAllow=\nLockPersonality=true\nNoNewPrivileges=true\nProcSubset=pid\nRemoveIPC=true\nSystemCallArchitectures=native\nUMask=0077 PrivateDevices=true\nPrivateTmp=true\nPrivateUsers=true ProtectClock=true\nProtectControlGroups=true\nProtectHome=read-only\nProtectHostname=true\nProtectKernelLogs=true\nProtectKernelModules=true\nProtectKernelTunables=true\nProtectProc=invisible\nProtectSystem=strict RestrictNamespaces=true\nRestrictRealtime=true\nRestrictSUIDSGID=true [Install]\nWantedBy=multi-user.target","breadcrumbs":"Deployment » systemd » systemd","id":"38","title":"systemd"},"39":{"body":"Support for different platforms (\"targets\") are organized into three tiers, each with a different set of guarantees. Targets are identified by the Rust \"target triple\" which is the string used when compiling cuprated. Attribute Tier 1 Tier 2 Tier 3 Official builds 🟢 🟢 🔴 Guaranteed to build 🟢 🟢 🟡 Automated testing 🟢 🟡 (some targets) 🔴 Manual testing 🟢 🟡 (sometimes) 🔴","breadcrumbs":"Platform support » Platform support","id":"39","title":"Platform support"},"4":{"body":"⚠️ This project is still in development; do NOT use cuprated for any serious purposes ⚠️ cuprated is fine to run for non-serious purposes and has a similar attack surface to other network connected services. See Resources for information on what system resources cuprated will use.","breadcrumbs":"Introduction » Is it safe to run cuprated?","id":"4","title":"Is it safe to run cuprated?"},"40":{"body":"Tier 1 targets can be thought of as \"guaranteed to work\". Target Notes x86_64-unknown-linux-gnu x64 Linux (glibc 2.36+) aarch64-unknown-linux-gnu ARM64 Linux (glibc 2.36+) aarch64-apple-darwin ARM64 macOS (11.0+)","breadcrumbs":"Platform support » Tier 1","id":"40","title":"Tier 1"},"41":{"body":"Tier 2 targets can be thought of as \"guaranteed to build\". Target Notes x86_64-pc-windows-msvc x64 Windows (MSVC, Windows Server 2022+) x86_64-apple-darwin x64 macOS","breadcrumbs":"Platform support » Tier 2","id":"41","title":"Tier 2"},"42":{"body":"Tier 3 targets are those which the Cuprate codebase likely can support, but which Cuprate does not build or test on a regular basis, so they may or may not work. Official builds are not available, but may eventually be planned. Target Notes x86_64-unknown-linux-musl x64 Linux (musl 1.2.3) aarch64-unknown-linux-musl ARM64 Linux (musl 1.2.3) x86_64-unknown-freebsd x64 FreeBSD aarch64-unknown-freebsd ARM64 FreeBSD aarch64-pc-windows-msvc ARM64 Windows (MSVC, Windows Server 2022+)","breadcrumbs":"Platform support » Tier 3","id":"42","title":"Tier 3"},"43":{"body":"The cuprated binary is distributed under the AGPL-3.0 license . Much of the codebase that makes up cuprated is under the MIT license . See also: https://github.com/Cuprate/cuprate/blob/main/LICENSE .","breadcrumbs":"License » License","id":"43","title":"License"},"5":{"body":"See Resources/Disk .","breadcrumbs":"Introduction » What files does cuprated create?","id":"5","title":"What files does cuprated create?"},"6":{"body":"Cuprate's node (cuprated) can currently: Sync the blockchain and transaction pool Broadcast and relay blocks and transactions Help other peers sync their blockchain","breadcrumbs":"Introduction » What can cuprated currently do?","id":"6","title":"What can cuprated currently do?"},"7":{"body":"The current full verification sync timings are around ~7.5x faster than monerod. In real terms, 16 hour full verification syncs and 4 hour fast-sync syncs have been reported on consumer grade hardware. On faster hardware (14 threads, 10Gbps networking), sub 2 hour fast-syncs have been reported. Various testing results can be found here .","breadcrumbs":"Introduction » How fast does cuprated sync?","id":"7","title":"How fast does cuprated sync?"},"8":{"body":"In the terminal running cuprated, type status. Use the help command to see the full list of commands.","breadcrumbs":"Introduction » How to see status of cuprated?","id":"8","title":"How to see status of cuprated?"},"9":{"body":"cuprated emits a message when it is fully synced: Synchronised with the network. It also logs its block height status when syncing, for example: 2025-05-01T22:17:10.270002Z INFO incoming_block{height=3402413 txs=66}: Successfully added block hash=\"e93464a7feea9b472dd734e61574e295f4b8f809c48ff78ef76d12111992ada7\"","breadcrumbs":"Introduction » How to tell cuprated is fully synced?","id":"9","title":"How to tell cuprated is fully synced?"}},"length":44,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"1":{"0":{"0":{"_":{"0":{"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"5":{"5":{"3":{"4":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{".":{"1":{".":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"0":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":2.23606797749979}}},"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"1":{"2":{"3":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"27":{"tf":1.0}}},"7":{"df":1,"docs":{"27":{"tf":1.0}}},"9":{"9":{"9":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"1":{"df":0,"docs":{},"t":{"2":{"2":{":":{"1":{"7":{":":{"1":{"0":{".":{"2":{"7":{"0":{"0":{"0":{"2":{"df":0,"docs":{},"z":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":2,"docs":{"27":{"tf":4.358898943540674},"35":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"2":{".":{"3":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.7320508075688772}}},"_":{"0":{"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":2.23606797749979}}},"df":1,"docs":{"27":{"tf":1.0}},"g":{"b":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"1":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":2.0}}},"4":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"5":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.0}}},"8":{"0":{"8":{"0":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{".":{"1":{"6":{"8":{".":{"1":{".":{"5":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.0},"20":{"tf":1.7320508075688772},"27":{"tf":2.23606797749979},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"2":{".":{"3":{"6":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"2":{"2":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}},"3":{"df":1,"docs":{"1":{"tf":1.0}}},"4":{"df":1,"docs":{"17":{"tf":1.0}}},"5":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"5":{"df":0,"docs":{},"g":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"0":{"df":0,"docs":{},"g":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"7":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"3":{".":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"31":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"27":{"tf":2.0}}},"5":{"df":1,"docs":{"27":{"tf":1.0}}},"df":2,"docs":{"39":{"tf":1.0},"42":{"tf":1.4142135623730951}}},"4":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}},"5":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"27":{"tf":2.23606797749979},"31":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"3":{"2":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"5":{"0":{"0":{"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}},"s":{"df":1,"docs":{"38":{"tf":1.0}}}},"6":{"4":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"28":{"tf":1.0}}},"df":0,"docs":{}},"7":{".":{"5":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"8":{"df":2,"docs":{"20":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772}}},"9":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"9":{"9":{"9":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"_":{",":{"_":{"df":0,"docs":{},"|":{"\\":{"_":{"_":{"\\":{"_":{"_":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"_":{"_":{"\\":{"_":{"_":{",":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":1,"docs":{"27":{"tf":2.6457513110645907}}},"df":1,"docs":{"27":{"tf":3.605551275463989}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}},"d":{"d":{"df":1,"docs":{"27":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":2,"docs":{"27":{"tf":2.0},"36":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"27":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":2.23606797749979},"28":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"6":{"4":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"21":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"23":{"tf":1.0}}},"i":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"38":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"38":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"3":{"tf":1.0}}}}}}},"t":{"a":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.0}}},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"43":{"tf":1.0}}}}},"d":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.4142135623730951}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"=":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"_":{"d":{"b":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"27":{"tf":2.0},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":3,"docs":{"27":{"tf":3.605551275463989},"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"9":{"0":{"0":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"k":{"df":2,"docs":{"0":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"24":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}},"o":{"a":{"d":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":9,"docs":{"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}},"c":{":":{"\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"\\":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"\\":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\\":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"\\":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}},"d":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}},"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"21":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"42":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}},"t":{"df":3,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"39":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":8,"docs":{"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":3.0},"28":{"tf":2.8284271247461903},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":2.8284271247461903},"33":{"tf":1.7320508075688772}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"27":{"tf":3.1622776601683795},"28":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":38,"docs":{"0":{"tf":2.0},"1":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":2.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":2.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":3.4641016151377544},"28":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":3.4641016151377544},"39":{"tf":1.0},"4":{"tf":2.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"'":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"6":{"tf":1.0}}},"d":{"'":{"df":3,"docs":{"10":{"tf":1.0},"27":{"tf":2.0},"29":{"tf":1.0}}},".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"24":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}}}},"t":{"a":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":2.0}}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"b":{"df":1,"docs":{"27":{"tf":2.0}}},"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"29":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"38":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"16":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"r":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":2.6457513110645907},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0}}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"27":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}},"t":{"c":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":2,"docs":{"3":{"tf":1.0},"42":{"tf":1.0}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":4.123105625617661},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"38":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"a":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"q":{"df":1,"docs":{"0":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":3,"docs":{"0":{"tf":1.0},"27":{"tf":2.449489742783178},"7":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"w":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":12,"docs":{"21":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":3.3166247903554},"28":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":2.6457513110645907},"5":{"tf":1.0}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":2.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"42":{"tf":2.0}}},"df":0,"docs":{}}},"df":2,"docs":{"17":{"tf":1.0},"27":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"2":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":2,"docs":{"27":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"g":{"b":{"df":2,"docs":{"20":{"tf":2.449489742783178},"31":{"tf":1.4142135623730951}}},"c":{"c":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"34":{"tf":1.0}}}}},"t":{"df":2,"docs":{"0":{"tf":1.0},"19":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":1.0},"29":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"b":{"c":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"=":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":2.0}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"=":{"\"":{"df":0,"docs":{},"e":{"9":{"3":{"4":{"6":{"4":{"a":{"7":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"a":{"9":{"b":{"4":{"7":{"2":{"d":{"d":{"7":{"3":{"4":{"df":0,"docs":{},"e":{"6":{"1":{"5":{"7":{"4":{"df":0,"docs":{},"e":{"2":{"9":{"5":{"df":0,"docs":{},"f":{"4":{"b":{"8":{"df":0,"docs":{},"f":{"8":{"0":{"9":{"c":{"4":{"8":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"7":{"8":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"7":{"6":{"d":{"1":{"2":{"1":{"1":{"1":{"9":{"9":{"2":{"a":{"d":{"a":{"7":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"p":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"/":{".":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"38":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{".":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{".":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":1,"docs":{"38":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}},"s":{":":{"/":{"/":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"b":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"q":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"3":{"6":{"5":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"{":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"=":{"3":{"4":{"0":{"2":{"4":{"1":{"3":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":3,"docs":{"27":{"tf":1.7320508075688772},"29":{"tf":1.0},"9":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"4":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.7320508075688772}},"v":{"4":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"v":{"6":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"j":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"14":{"tf":1.7320508075688772},"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":3.1622776601683795}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"1":{"6":{"3":{"8":{"4":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"x":{"df":8,"docs":{"21":{"tf":2.0},"23":{"tf":1.0},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":2.0},"42":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"27":{"tf":2.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.0}}}}},"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"a":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"27":{"tf":2.6457513110645907},"34":{"tf":1.0},"9":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":8,"docs":{"21":{"tf":2.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":3,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":2.449489742783178},"43":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"x":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"38":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}}}}}},"b":{"/":{"df":1,"docs":{"20":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}},"y":{"a":{"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"=":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"=":{"4":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"x":{"=":{"4":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"s":{"c":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"m":{"df":1,"docs":{"34":{"tf":1.0}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"d":{"'":{"df":1,"docs":{"10":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.7320508075688772},"38":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"v":{"c":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"27":{"tf":2.23606797749979},"43":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":2.0}}}}},"v":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":8,"docs":{"13":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"4":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}},"w":{"df":2,"docs":{"15":{"tf":1.0},"27":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"2":{"tf":2.0},"38":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"20":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":4.123105625617661},"29":{"tf":3.0}}}}},"df":0,"docs":{}}}},"o":{"c":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"c":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}},"r":{"df":3,"docs":{"2":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":5,"docs":{"26":{"tf":1.0},"27":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":2,"docs":{"14":{"tf":1.0},"27":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"2":{"df":0,"docs":{},"p":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"35":{"tf":1.0}}}}}}},"df":4,"docs":{"27":{"tf":1.7320508075688772},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"c":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":2,"docs":{"27":{"tf":2.8284271247461903},"6":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":1,"docs":{"20":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"42":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"21":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":2.8284271247461903},"34":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"35":{"tf":2.23606797749979}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":4,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"n":{"df":3,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0}}},"s":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"27":{"tf":1.0}}}},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}},"y":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":1,"docs":{"38":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"s":{"df":8,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"a":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"c":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"20":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":1,"docs":{"38":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"c":{"=":{"5":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"d":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"p":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"df":2,"docs":{"12":{"tf":1.0},"29":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":8,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":2.0},"4":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"27":{"tf":2.449489742783178}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"19":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":16,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"38":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"27":{"tf":1.0},"38":{"tf":2.8284271247461903},"4":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":4,"docs":{"27":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":1,"docs":{"22":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"27":{"tf":2.0}},"n":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"27":{"tf":2.449489742783178}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"22":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"27":{"tf":1.4142135623730951},"38":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"5":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"=":{"3":{"0":{"0":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}},"u":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"4":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"31":{"tf":1.0}},"e":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"39":{"tf":1.0}}}}}}},"u":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"38":{"tf":2.23606797749979}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":4,"docs":{"27":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178},"9":{"tf":1.7320508075688772}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"4":{"5":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"@":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"~":{"@":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.7320508075688772}}}}},"d":{"df":1,"docs":{"38":{"tf":2.0}}},"df":9,"docs":{"1":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":2.6457513110645907},"30":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"23":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"_":{"b":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"27":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}},"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"7":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"17":{"tf":1.0},"27":{"tf":2.449489742783178},"7":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"7":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"=":{"6":{"0":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":2.0}}}}},"l":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":1,"docs":{"23":{"tf":1.0}}}},"r":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":2.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.0},"34":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"27":{"tf":2.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"=":{"6":{"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":3,"docs":{"27":{"tf":4.58257569495584},"29":{"tf":1.0},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"=":{"0":{"0":{"7":{"7":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":2.0}}}}}}}},"p":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"22":{"tf":1.0},"43":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"28":{"tf":1.0}}}},"df":14,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"=":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"a":{"d":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.4142135623730951},"3":{"tf":1.0},"38":{"tf":1.7320508075688772}},"s":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"27":{"tf":4.69041575982343}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"27":{"tf":5.5677643628300215},"28":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"s":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":3.3166247903554}}}}}}}},"i":{"a":{"df":1,"docs":{"13":{"tf":1.0}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}},"y":{"df":2,"docs":{"21":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"21":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}}}}}},"x":{".":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"z":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"6":{"4":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":3,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{"df":4,"docs":{"21":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"df":1,"docs":{"23":{"tf":1.0}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"1":{"0":{"0":{"_":{"0":{"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"5":{"5":{"3":{"4":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{".":{"1":{".":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"0":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":2.23606797749979}}},"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"1":{"2":{"3":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"27":{"tf":1.0}}},"7":{"df":1,"docs":{"27":{"tf":1.0}}},"9":{"9":{"9":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"1":{"df":0,"docs":{},"t":{"2":{"2":{":":{"1":{"7":{":":{"1":{"0":{".":{"2":{"7":{"0":{"0":{"0":{"2":{"df":0,"docs":{},"z":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":2,"docs":{"27":{"tf":4.358898943540674},"35":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"2":{".":{"3":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.7320508075688772}}},"_":{"0":{"0":{"0":{",":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":2.23606797749979}}},"df":1,"docs":{"27":{"tf":1.0}},"g":{"b":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"1":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"3":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"8":{"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":2.0}}},"4":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"5":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.0}}},"8":{"0":{"8":{"0":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{".":{"1":{"6":{"8":{".":{"1":{".":{"5":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.0},"20":{"tf":1.7320508075688772},"27":{"tf":2.23606797749979},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"2":{".":{"3":{"6":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"2":{"2":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}},"3":{"df":1,"docs":{"1":{"tf":1.0}}},"4":{"df":1,"docs":{"17":{"tf":1.0}}},"5":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"5":{"df":0,"docs":{},"g":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"0":{"df":0,"docs":{},"g":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":5,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.7320508075688772},"7":{"tf":1.0}},"g":{"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"3":{".":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"31":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"27":{"tf":2.0}}},"5":{"df":1,"docs":{"27":{"tf":1.0}}},"df":2,"docs":{"39":{"tf":1.0},"42":{"tf":1.7320508075688772}}},"4":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}},"5":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"20":{"tf":1.0},"27":{"tf":2.23606797749979},"31":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"3":{"2":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"5":{"0":{"0":{"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}},"s":{"df":1,"docs":{"38":{"tf":1.0}}}},"6":{"4":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"28":{"tf":1.0}}},"df":0,"docs":{}},"7":{".":{"5":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"8":{"df":2,"docs":{"20":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772}}},"9":{"0":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"9":{"9":{"9":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"_":{",":{"_":{"df":0,"docs":{},"|":{"\\":{"_":{"_":{"\\":{"_":{"_":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"_":{"_":{"\\":{"_":{"_":{",":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":1,"docs":{"27":{"tf":2.6457513110645907}}},"df":1,"docs":{"27":{"tf":3.605551275463989}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}},"d":{"d":{"df":1,"docs":{"27":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"/":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":2,"docs":{"27":{"tf":2.0},"36":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"27":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":2.23606797749979},"28":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"6":{"4":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"21":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"36":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"23":{"tf":1.0}}},"i":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"12":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"38":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"38":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"3":{"tf":1.0}}}}}}},"t":{"a":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"n":{"/":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"43":{"tf":1.0}}}}},"d":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.4142135623730951}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"=":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"_":{"d":{"b":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"27":{"tf":2.0},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":3,"docs":{"27":{"tf":3.605551275463989},"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"9":{"0":{"0":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"k":{"df":2,"docs":{"0":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"24":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}},"o":{"a":{"d":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":9,"docs":{"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.0},"23":{"tf":2.0},"24":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":4,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}},"c":{":":{"\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"\\":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"\\":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\\":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"\\":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772}},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}},"d":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}},"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"21":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"42":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"28":{"tf":2.0},"29":{"tf":1.0},"38":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}},"t":{"df":3,"docs":{"0":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"39":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":8,"docs":{"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":3.0},"28":{"tf":2.8284271247461903},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":3.0},"33":{"tf":2.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"27":{"tf":3.1622776601683795},"28":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":38,"docs":{"0":{"tf":2.0},"1":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":2.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":3.4641016151377544},"28":{"tf":1.4142135623730951},"29":{"tf":2.449489742783178},"3":{"tf":2.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":3.4641016151377544},"39":{"tf":1.0},"4":{"tf":2.23606797749979},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"e":{"'":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"6":{"tf":1.0}}},"d":{"'":{"df":3,"docs":{"10":{"tf":1.0},"27":{"tf":2.0},"29":{"tf":1.0}}},".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"22":{"tf":1.0},"24":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}}}},"t":{"a":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":2.0},"11":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":2.0}}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"b":{"df":1,"docs":{"27":{"tf":2.0}}},"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"29":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":2,"docs":{"37":{"tf":2.0},"38":{"tf":1.4142135623730951}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"16":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.4142135623730951}}}}}},"r":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":2.6457513110645907},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":5,"docs":{"20":{"tf":1.4142135623730951},"31":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"32":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0}}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"21":{"tf":2.0},"27":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}},"t":{"c":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":2,"docs":{"3":{"tf":1.0},"42":{"tf":1.0}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":4.123105625617661},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"38":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"a":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"q":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":3,"docs":{"0":{"tf":1.0},"27":{"tf":2.449489742783178},"7":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"w":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":12,"docs":{"21":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"27":{"tf":3.3166247903554},"28":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":2.6457513110645907},"5":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":2.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"42":{"tf":2.0}}},"df":0,"docs":{}}},"df":2,"docs":{"17":{"tf":1.0},"27":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"2":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":2,"docs":{"27":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"g":{"b":{"df":2,"docs":{"20":{"tf":2.449489742783178},"31":{"tf":1.4142135623730951}}},"c":{"c":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"34":{"tf":1.0}}}}},"t":{"df":8,"docs":{"0":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"22":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":1.0},"29":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"b":{"c":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"=":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":2.0}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"=":{"\"":{"df":0,"docs":{},"e":{"9":{"3":{"4":{"6":{"4":{"a":{"7":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"a":{"9":{"b":{"4":{"7":{"2":{"d":{"d":{"7":{"3":{"4":{"df":0,"docs":{},"e":{"6":{"1":{"5":{"7":{"4":{"df":0,"docs":{},"e":{"2":{"9":{"5":{"df":0,"docs":{},"f":{"4":{"b":{"8":{"df":0,"docs":{},"f":{"8":{"0":{"9":{"c":{"4":{"8":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"7":{"8":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"7":{"6":{"d":{"1":{"2":{"1":{"1":{"1":{"9":{"9":{"2":{"a":{"d":{"a":{"7":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"p":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"/":{".":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"38":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"/":{".":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{".":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":1,"docs":{"38":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}},"s":{":":{"/":{"/":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"b":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"q":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"3":{"6":{"5":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"c":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"{":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"=":{"3":{"4":{"0":{"2":{"4":{"1":{"3":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":3,"docs":{"27":{"tf":1.7320508075688772},"29":{"tf":1.0},"9":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"4":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":19,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":2.23606797749979}},"v":{"4":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"v":{"6":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0}}}}},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"j":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"29":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":2,"docs":{"14":{"tf":2.0},"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":3.1622776601683795}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":2.23606797749979}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"=":{"1":{"6":{"3":{"8":{"4":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":8,"docs":{"21":{"tf":2.0},"23":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":2.0},"42":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"21":{"tf":1.0},"27":{"tf":2.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.0}}}}},"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"a":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"27":{"tf":2.6457513110645907},"34":{"tf":1.0},"9":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"{":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":8,"docs":{"21":{"tf":2.0},"24":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":3,"docs":{"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":2.449489742783178},"43":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"x":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"38":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":2.23606797749979}}}}}}}},"b":{"/":{"df":1,"docs":{"20":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}},"y":{"a":{"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"=":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"=":{"4":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"x":{"=":{"4":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"27":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"s":{"c":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"m":{"df":1,"docs":{"34":{"tf":1.0}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"d":{"'":{"df":1,"docs":{"10":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.7320508075688772},"38":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"v":{"c":{"df":2,"docs":{"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"27":{"tf":2.23606797749979},"43":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":2.0}}}}},"v":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"4":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}}},"w":{"df":2,"docs":{"15":{"tf":1.0},"27":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"2":{"tf":2.0},"38":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"20":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":4.123105625617661},"29":{"tf":3.0}}}}},"df":0,"docs":{}}}},"o":{"c":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"c":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}},"r":{"df":3,"docs":{"2":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":5,"docs":{"26":{"tf":1.0},"27":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}},"u":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":2,"docs":{"14":{"tf":1.0},"27":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"2":{"df":0,"docs":{},"p":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"35":{"tf":1.0}}}}}}},"df":4,"docs":{"27":{"tf":1.7320508075688772},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"c":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":2,"docs":{"27":{"tf":2.8284271247461903},"6":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":1,"docs":{"20":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"42":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"21":{"tf":1.7320508075688772},"39":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":2.8284271247461903},"34":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"35":{"tf":2.6457513110645907}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":4,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"17":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"n":{"df":3,"docs":{"0":{"tf":1.0},"25":{"tf":1.0},"38":{"tf":1.0}}},"s":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"27":{"tf":1.0}}}},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}},"y":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":1,"docs":{"38":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"s":{"df":8,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"a":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"c":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"20":{"tf":2.449489742783178},"23":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":9,"docs":{"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":1,"docs":{"38":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"c":{"=":{"5":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"d":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"p":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"df":2,"docs":{"12":{"tf":1.0},"29":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":8,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":2.0},"4":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"27":{"tf":2.449489742783178}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"19":{"tf":1.0},"30":{"tf":1.0},"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":16,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"38":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"41":{"tf":1.0},"42":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"27":{"tf":1.0},"38":{"tf":2.8284271247461903},"4":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":4,"docs":{"27":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":1,"docs":{"22":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"27":{"tf":2.0}},"n":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"27":{"tf":2.449489742783178}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"22":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"14":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"38":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"5":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"=":{"3":{"0":{"0":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"32":{"tf":1.0}}},"u":{"df":2,"docs":{"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.7320508075688772},"4":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"31":{"tf":1.0}},"e":{".":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"39":{"tf":1.0}}}}}}},"u":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":2,"docs":{"23":{"tf":1.7320508075688772},"38":{"tf":2.23606797749979}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":6,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":4,"docs":{"27":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"9":{"tf":2.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"4":{"5":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"@":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"~":{"@":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.7320508075688772}}}}},"d":{"df":1,"docs":{"38":{"tf":2.449489742783178}}},"df":9,"docs":{"1":{"tf":1.0},"20":{"tf":2.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":2.6457513110645907},"30":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"23":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"24":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"_":{"b":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"27":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}},"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"7":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"42":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"17":{"tf":1.0},"27":{"tf":2.449489742783178},"7":{"tf":1.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"39":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"7":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"=":{"6":{"0":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"27":{"tf":2.0}}}}},"l":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":1,"docs":{"23":{"tf":1.0}}}},"r":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":2.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"27":{"tf":1.0},"34":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"27":{"tf":2.0}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"d":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"s":{"=":{"6":{"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":3,"docs":{"27":{"tf":4.58257569495584},"29":{"tf":1.0},"8":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"=":{"0":{"0":{"7":{"7":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":2.0}}}}}}}},"p":{"/":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":2,"docs":{"22":{"tf":1.0},"43":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"28":{"tf":1.0}}}},"df":14,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"=":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"a":{"d":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.4142135623730951},"3":{"tf":1.0},"38":{"tf":1.7320508075688772}},"s":{"/":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"27":{"tf":4.69041575982343}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"27":{"tf":5.5677643628300215},"28":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"s":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":3.4641016151377544}}}}}}}},"i":{"a":{"df":1,"docs":{"13":{"tf":1.0}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"y":{"=":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}},"y":{"df":2,"docs":{"21":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"21":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.7320508075688772},"42":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"12":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}}}}}},"x":{".":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"z":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"6":{"4":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":3,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{"df":4,"docs":{"21":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"df":1,"docs":{"23":{"tf":1.0}}}}},"title":{"root":{"1":{"df":1,"docs":{"40":{"tf":1.0}}},"2":{"df":1,"docs":{"41":{"tf":1.0}}},"3":{"df":1,"docs":{"42":{"tf":1.0}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"33":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"6":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"q":{"df":1,"docs":{"0":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"11":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"a":{"d":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.0},"4":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"19":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"29":{"tf":1.0}}}}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});